<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'country', 'Type', 'date_birth', 'type_study', 'brief', 'image', 'degree', 'user_role');

	public function categories()
	{
		return $this->hasMany('App\Models\Category', 'created_by');
	}

	public function books()
	{
		return $this->hasMany('App\Models\Book', 'author_id');
	}

	public function comments()
	{
		return $this->hasMany('App\Models\Comment', 'user_id');
	}

	public function books_favorite()
	{
		return $this->hasMany('App\Models\BookFavorite', 'user_id');
	}

	public function categories_parents()
	{
		return $this->hasMany('App\Models\CategoryParent', 'user_id');
	}

	public function favorite_departments()
	{
		return $this->hasMany('App\Models\FavoriteDepartment', 'user_id');
	}

}