<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('veron_id');
			$table->integer('company_id');
			$table->string('name', 191);
			$table->text('detail')->nullable();
			$table->string('version', 191)->nullable();
			$table->string('live_url', 191)->nullable();
			$table->string('test_url', 191)->nullable();
			$table->string('html_url', 191)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}