<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('veron_id', 'status', 'name', 'email', 'phone', 'website');
	protected $visible = array('veron_id', 'status', 'name', 'email', 'phone', 'website');

	public function projects()
	{
		return $this->belongsTo('Project');
	}

	public function contracts()
	{
		return $this->hasMany('Contract');
	}

}