<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ticket extends Model 
{

    protected $table = 'tickets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('status_id', 'company_id', 'project_id', 'type_id', 'priority_id', 'name', 'detail', 'start_time', 'finish_time', 'working_hours', 'problem_reason', 'problem_solution');
    protected $visible = array('status_id', 'company_id', 'project_id', 'type_id', 'priority_id', 'name', 'detail', 'start_time', 'finish_time', 'working_hours', 'problem_reason', 'problem_solution');

    public function users()
    {
        return $this->belongsToMany('User', 'user_task', 'task_id', 'user_id');
    }

    public function project()
    {
        return $this->hasOne('Project');
    }

    public function attachments()
    {
        return $this->morphToMany('Attachment');
    }

    public function comments()
    {
        return $this->hasMany('Comment');
    }

    public function status()
    {
        return $this->hasOne('TicketStatus');
    }

    public function type()
    {
        return $this->hasOne('TicketType');
    }

    public function priority()
    {
        return $this->hasOne('TicketPriority');
    }

    public function tasks()
    {
        return $this->hasMany('Task');
    }

}