<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contract extends Model 
{

    protected $table = 'contracts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('company_id', 'project_id', 'type_id', 'start_date', 'finish_date', 'working_hours');
    protected $visible = array('company_id', 'project_id', 'type_id', 'start_date', 'finish_date', 'working_hours');

    public function company()
    {
        return $this->belongsTo('Company');
    }

    public function project()
    {
        return $this->belongsTo('Project');
    }

    public function type()
    {
        return $this->hasOne('ContractType');
    }

}