<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccessoryBondItemsTable extends Migration {

	public function up()
	{
		Schema::create('accessory_bond_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('product_id')->unsigned();
			$table->double('weight')->nullable();
			$table->double('gold_weight')->nullable();
			$table->integer('carat_id')->unsigned();
			$table->double('accessory_value')->nullable();
			$table->integer('accessory_count')->unsigned()->nullable();
			$table->double('accessory_stone_weight')->nullable();
			$table->double('accessory_tax')->nullable();
			$table->double('discount')->nullable();
			$table->double('other_stones_weight')->nullable();
			$table->longText('notes')->nullable();
			$table->integer('bond_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('accessory_bond_items');
	}
}