<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('account_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->morphs('account');
			$table->decimal('value');
			$table->json('unit');
			$table->enum('type', array('a', 'b', 'c', 'd'));
			$table->text('text_ar')->nullable();
			$table->text('text_en')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('account_transactions');
	}
}