<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountsTable extends Migration {

	public function up()
	{
		Schema::create('accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 255)->index();
			$table->string('name_en', 255)->nullable()->index();
			$table->integer('numeric_system');
			$table->string('unit', 255);
			$table->enum('type', array('a', 'b', 'c', 'd'));
			$table->integer('tree_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('accounts');
	}
}