<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchCategoryExceptionsTable extends Migration {

	public function up()
	{
		Schema::create('branch_category_exceptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('branch_id');
			$table->integer('category_id');
			$table->double('discount_price')->nullable();
			$table->double('ratio');
			$table->integer('returned_days');
		});
	}

	public function down()
	{
		Schema::drop('branch_category_exceptions');
	}
}