<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('documents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('type');
			$table->string('file')->nullable();
			$table->string('name')->nullable();
			$table->string('company_name')->nullable();
			$table->string('document_number')->nullable();
			$table->date('start_date')->nullable();
			$table->string('end_date')->nullable();
			$table->integer('reminder_days')->nullable();
			$table->text('details')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('documents');
	}
}