<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('kind_id');
			$table->integer('country_id');
			$table->integer('color_id');
			$table->string('model_num');
			$table->morphs('size');
			$table->integer('karat_id');
			$table->double('weight');
			$table->double('wege');
			$table->string('img');
			$table->text('description')->nullable();
			$table->text('stone_description');
			$table->boolean('has_stone');
			$table->enum('metal_type', array('gold', 'other'));
			$table->double('cost');
			$table->double('conversion');
			$table->double('other_cost');
			$table->double('currency_cost');
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}