<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReturnedBondItemsTable extends Migration {

	public function up()
	{
		Schema::create('returned_bond_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('line_id');
			$table->integer('karat');
			$table->double('item_weight');
			$table->integer('purity');
			$table->double('wage')->nullable();
			$table->integer('count_item');
			$table->double('item_value')->nullable();
			$table->double('rock_weight')->nullable();
			$table->double('diamond_weight')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('returned_bond_items');
	}
}