<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubAccountsTable extends Migration {

	public function up()
	{
		Schema::create('sub_accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 255)->index();
			$table->string('name_en', 255)->nullable()->index();
			$table->json('unit');
			$table->enum('type', array('a', 'b', 'c', 'd'));
			$table->integer('account_id')->unsigned();
			$table->integer('numeric_system');
			$table->integer('parent_id');
			$table->boolean('has_child')->default(0);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sub_accounts');
	}
}