<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuppliersTable extends Migration {

	public function up()
	{
		Schema::create('suppliers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('nid');
			$table->enum('type', array('local', 'foreign'))->nullable();
			$table->enum('dealing_type', array('gold_tax', 'wages_tax'))->nullable();
			$table->bigInteger('country_id')->unsigned()->index();
			$table->bigInteger('city_id')->unsigned()->index();
			$table->string('company_name')->nullable();
			$table->date('establishment_date');
			$table->string('logo')->nullable();
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->string('phone')->nullable();
			$table->string('email')->nullable();
			$table->string('communication_officer')->nullable();
			$table->string('communication_phone')->nullable();
			$table->string('communication_email')->nullable();
			$table->string('password');
			$table->string('address')->nullable();
			$table->string('building_number')->nullable();
			$table->string('sub_number')->nullable();
			$table->string('street_number')->nullable();
			$table->string('district')->nullable();
			$table->text('details')->nullable();
			$table->enum('tax', array('no', 'gold', 'wages', 'gold&wages'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('suppliers');
	}
}