<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSupplyBondTable extends Migration {

	public function up()
	{
		Schema::create('supply_bond', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamp('bond_date');
			$table->morphs('buyer');
			$table->morphs('seller');
			$table->text('bond_num')->nullable();
			$table->double('gold_price')->nullable();
			$table->double('entity_gold_price');
			$table->double('out_goods_value')->nullable();
			$table->longText('notes')->nullable();
			$table->string('bond_docs');
			$table->string('out_docs')->nullable();
			$table->enum('bond_type', array('gold', 'diamond', 'accessory'))->nullable();
			$table->softDeletes();
			$table->timestamps();
			$table->double('total_value')->nullable();
			$table->string('diamond_weight');
			$table->double('total_other_rocks')->nullable();
			$table->double('total_accories')->nullable();
			$table->string('total_gold_18')->nullable();
			$table->string('total_gold_21')->nullable();
			$table->string('total_gold_22')->nullable();
			$table->double('total_gold_24')->nullable();
			$table->string('total_gold_by24');
			$table->string('total_weight')->nullable();
			$table->string('total_discount');
			$table->double('total_tax')->nullable();
			$table->double('total_count')->nullable();
			$table->enum('status', array('opend', 'closed'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('supply_bond');
	}
}