<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMonitoringsTable extends Migration {

	public function up()
	{
		Schema::create('monitorings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('project_id')->unsigned();
			$table->integer('project_status_id')->unsigned();
			$table->integer('monitoring_status_id')->unsigned();
			$table->integer('owner_user_id')->unsigned();
			$table->integer('monitoring_institute_id')->unsigned();
			$table->string('name');
			$table->text('remark')->nullable();
			$table->date('monitoring_date');
			$table->text('result')->nullable();
			$table->boolean('action_required')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('monitorings');
	}
}