<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProcurementsTable extends Migration {

	public function up()
	{
		Schema::create('procurements', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('project_id')->unsigned();
			$table->integer('project_status_id')->unsigned();
			$table->integer('procurement_status_id')->unsigned();
			$table->integer('procurement_type_id')->unsigned();
			$table->integer('owner_user_id')->unsigned();
			$table->integer('procurement_subject_id')->unsigned();
			$table->integer('partner_id')->unsigned()->nullable();
			$table->string('name');
			$table->text('remark')->nullable();
			$table->boolean('condition_of_contract');
			$table->boolean('public_procurement_limit');
			$table->boolean('eu_limit')->nullable();
			$table->bigInteger('procurement_amount')->unsigned();
			$table->boolean('has_partner');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('procurements');
	}
}