<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('institute_id')->references('id')->on('institutes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('owner_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('institute_id')->references('id')->on('institutes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('project_status_id')->references('id')->on('project_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('sub_status_id')->references('id')->on('project_sub_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('project_type_id')->references('id')->on('project_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('prev_project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_sub_statuses', function(Blueprint $table) {
			$table->foreign('project_status_id')->references('id')->on('project_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_sub_statuses', function(Blueprint $table) {
			$table->foreign('next_status_id')->references('id')->on('project_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_sub_statuses', function(Blueprint $table) {
			$table->foreign('next_sub_status_id')->references('id')->on('project_sub_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_partner', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_partner', function(Blueprint $table) {
			$table->foreign('partner_id')->references('id')->on('partners')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_keyword', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_keyword', function(Blueprint $table) {
			$table->foreign('keyword_id')->references('id')->on('keywords')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('project_status_id')->references('id')->on('project_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('payment_status_id')->references('id')->on('payment_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('payment_type_id')->references('id')->on('payment_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('owner_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('milestone_id')->references('id')->on('milestones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('milestones', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('milestones', function(Blueprint $table) {
			$table->foreign('project_status_id')->references('id')->on('project_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('milestones', function(Blueprint $table) {
			$table->foreign('milestone_status_id')->references('id')->on('milestone_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('milestones', function(Blueprint $table) {
			$table->foreign('owner_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_user', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modifies', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modifies', function(Blueprint $table) {
			$table->foreign('project_status_id')->references('id')->on('project_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modifies', function(Blueprint $table) {
			$table->foreign('modify_status_id')->references('id')->on('modify_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modifies', function(Blueprint $table) {
			$table->foreign('modify_type_id')->references('id')->on('modify_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modifies', function(Blueprint $table) {
			$table->foreign('owner_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modifies', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('monitorings', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('monitorings', function(Blueprint $table) {
			$table->foreign('project_status_id')->references('id')->on('project_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('monitorings', function(Blueprint $table) {
			$table->foreign('monitoring_status_id')->references('id')->on('monitoring_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('monitorings', function(Blueprint $table) {
			$table->foreign('owner_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('monitorings', function(Blueprint $table) {
			$table->foreign('monitoring_institute_id')->references('id')->on('monitoring_institutes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->foreign('project_status_id')->references('id')->on('project_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->foreign('procurement_status_id')->references('id')->on('procurement_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->foreign('procurement_type_id')->references('id')->on('procurement_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->foreign('owner_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->foreign('procurement_subject_id')->references('id')->on('procurement_subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->foreign('partner_id')->references('id')->on('partners')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('statements', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('statements', function(Blueprint $table) {
			$table->foreign('statement_status_id')->references('id')->on('statement_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('statements', function(Blueprint $table) {
			$table->foreign('statement_type_id')->references('id')->on('statement_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('statements', function(Blueprint $table) {
			$table->foreign('owner_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->foreign('owner_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->foreign('milestone_id')->references('id')->on('milestones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->foreign('modify_id')->references('id')->on('modifies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->foreign('monitoring_id')->references('id')->on('monitorings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->foreign('procurement_id')->references('id')->on('procurements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->foreign('statement_id')->references('id')->on('statements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('old_project_status_id')->references('id')->on('project_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('new_project_status_id')->references('id')->on('project_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('old_sub_status_id')->references('id')->on('project_sub_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('new_sub_status_id')->references('id')->on('project_sub_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('milestone_id')->references('id')->on('milestones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('old_milestone_status_id')->references('id')->on('milestone_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('new_milestone_status_id')->references('id')->on('milestone_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('old_payment_status_id')->references('id')->on('payment_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('new_payment_status_id')->references('id')->on('payment_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('modify_id')->references('id')->on('modifies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('old_modify_status_id')->references('id')->on('modify_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('new_modify_status_id')->references('id')->on('modify_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('monitoring_id')->references('id')->on('monitorings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('old_monitoring_status_id')->references('id')->on('monitoring_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('new_monitoring_status_id')->references('id')->on('monitoring_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('procurement_id')->references('id')->on('procurements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('old_procurement_status_id')->references('id')->on('procurement_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('new_procurement_status_id')->references('id')->on('procurement_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('statement_id')->references('id')->on('statements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('old_statement_status_id')->references('id')->on('statement_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('new_statement_status_id')->references('id')->on('statement_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_financing', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_financing', function(Blueprint $table) {
			$table->foreign('financing_id')->references('id')->on('financings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event_sub_types', function(Blueprint $table) {
			$table->foreign('event_type_id')->references('id')->on('event_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('event_type_id')->references('id')->on('event_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('event_sub_type_id')->references('id')->on('event_sub_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_institute_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_owner_user_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_institute_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_project_status_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_sub_status_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_project_type_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_prev_project_id_foreign');
		});
		Schema::table('project_sub_statuses', function(Blueprint $table) {
			$table->dropForeign('project_sub_statuses_project_status_id_foreign');
		});
		Schema::table('project_sub_statuses', function(Blueprint $table) {
			$table->dropForeign('project_sub_statuses_next_status_id_foreign');
		});
		Schema::table('project_sub_statuses', function(Blueprint $table) {
			$table->dropForeign('project_sub_statuses_next_sub_status_id_foreign');
		});
		Schema::table('project_partner', function(Blueprint $table) {
			$table->dropForeign('project_partner_project_id_foreign');
		});
		Schema::table('project_partner', function(Blueprint $table) {
			$table->dropForeign('project_partner_partner_id_foreign');
		});
		Schema::table('project_keyword', function(Blueprint $table) {
			$table->dropForeign('project_keyword_project_id_foreign');
		});
		Schema::table('project_keyword', function(Blueprint $table) {
			$table->dropForeign('project_keyword_keyword_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_project_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_project_status_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_payment_status_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_payment_type_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_owner_user_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_milestone_id_foreign');
		});
		Schema::table('milestones', function(Blueprint $table) {
			$table->dropForeign('milestones_project_id_foreign');
		});
		Schema::table('milestones', function(Blueprint $table) {
			$table->dropForeign('milestones_project_status_id_foreign');
		});
		Schema::table('milestones', function(Blueprint $table) {
			$table->dropForeign('milestones_milestone_status_id_foreign');
		});
		Schema::table('milestones', function(Blueprint $table) {
			$table->dropForeign('milestones_owner_user_id_foreign');
		});
		Schema::table('project_user', function(Blueprint $table) {
			$table->dropForeign('project_user_project_id_foreign');
		});
		Schema::table('project_user', function(Blueprint $table) {
			$table->dropForeign('project_user_user_id_foreign');
		});
		Schema::table('modifies', function(Blueprint $table) {
			$table->dropForeign('modifies_project_id_foreign');
		});
		Schema::table('modifies', function(Blueprint $table) {
			$table->dropForeign('modifies_project_status_id_foreign');
		});
		Schema::table('modifies', function(Blueprint $table) {
			$table->dropForeign('modifies_modify_status_id_foreign');
		});
		Schema::table('modifies', function(Blueprint $table) {
			$table->dropForeign('modifies_modify_type_id_foreign');
		});
		Schema::table('modifies', function(Blueprint $table) {
			$table->dropForeign('modifies_owner_user_id_foreign');
		});
		Schema::table('modifies', function(Blueprint $table) {
			$table->dropForeign('modifies_payment_id_foreign');
		});
		Schema::table('monitorings', function(Blueprint $table) {
			$table->dropForeign('monitorings_project_id_foreign');
		});
		Schema::table('monitorings', function(Blueprint $table) {
			$table->dropForeign('monitorings_project_status_id_foreign');
		});
		Schema::table('monitorings', function(Blueprint $table) {
			$table->dropForeign('monitorings_monitoring_status_id_foreign');
		});
		Schema::table('monitorings', function(Blueprint $table) {
			$table->dropForeign('monitorings_owner_user_id_foreign');
		});
		Schema::table('monitorings', function(Blueprint $table) {
			$table->dropForeign('monitorings_monitoring_institute_id_foreign');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->dropForeign('procurements_project_id_foreign');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->dropForeign('procurements_project_status_id_foreign');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->dropForeign('procurements_procurement_status_id_foreign');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->dropForeign('procurements_procurement_type_id_foreign');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->dropForeign('procurements_owner_user_id_foreign');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->dropForeign('procurements_procurement_subject_id_foreign');
		});
		Schema::table('procurements', function(Blueprint $table) {
			$table->dropForeign('procurements_partner_id_foreign');
		});
		Schema::table('statements', function(Blueprint $table) {
			$table->dropForeign('statements_project_id_foreign');
		});
		Schema::table('statements', function(Blueprint $table) {
			$table->dropForeign('statements_statement_status_id_foreign');
		});
		Schema::table('statements', function(Blueprint $table) {
			$table->dropForeign('statements_statement_type_id_foreign');
		});
		Schema::table('statements', function(Blueprint $table) {
			$table->dropForeign('statements_owner_user_id_foreign');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->dropForeign('alerts_project_id_foreign');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->dropForeign('alerts_owner_user_id_foreign');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->dropForeign('alerts_milestone_id_foreign');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->dropForeign('alerts_payment_id_foreign');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->dropForeign('alerts_modify_id_foreign');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->dropForeign('alerts_monitoring_id_foreign');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->dropForeign('alerts_procurement_id_foreign');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->dropForeign('alerts_statement_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_project_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_user_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_old_project_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_new_project_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_old_sub_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_new_sub_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_milestone_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_old_milestone_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_new_milestone_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_payment_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_old_payment_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_new_payment_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_modify_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_old_modify_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_new_modify_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_monitoring_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_old_monitoring_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_new_monitoring_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_procurement_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_old_procurement_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_new_procurement_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_statement_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_old_statement_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_new_statement_status_id_foreign');
		});
		Schema::table('project_financing', function(Blueprint $table) {
			$table->dropForeign('project_financing_project_id_foreign');
		});
		Schema::table('project_financing', function(Blueprint $table) {
			$table->dropForeign('project_financing_financing_id_foreign');
		});
		Schema::table('event_sub_types', function(Blueprint $table) {
			$table->dropForeign('event_sub_types_event_type_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_project_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_event_type_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_event_sub_type_id_foreign');
		});
	}
}