<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('User', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('email', 320)->unique();
			$table->string('first_name', 70);
			$table->string('last_name', 70);
			$table->string('phone_number', 10)->unique();
			$table->date('birth_date');
			$table->string('birth_place')->nullable();
			$table->time('birth_time');
			$table->enum('gender', array('male', 'female'));
			$table->string('religion');
			$table->string('caste');
			$table->string('sub_caste')->nullable();
			$table->enum('marital_status', array('Nevermarried', 'Divorced', 'AwaitingDivorced', 'Widowed', 'Annulled'));
			$table->string('country');
			$table->decimal('height', 5,2);
			$table->string('state');
			$table->string('current_city');
			$table->string('native_city');
			$table->string('degree');
			$table->string('occupation');
			$table->string('income');
			$table->enum('family_type', array('jointfamily', 'nuclearfamily', 'other'));
			$table->string('father_name');
			$table->string('father_occupation');
			$table->string('mother_name');
			$table->string('mother_occupation');
			$table->integer('brothers');
			$table->integer('sisters');
			$table->integer('married_brothers');
			$table->integer('married_sisters');
			$table->string('address');
			$table->string('maternal_surname');
			$table->string('physical_disablility');
			$table->decimal('lat', 10,8)->nullable();
			$table->decimal('lng', 11,8)->nullable();
			$table->boolean('smoke')->nullable();
			$table->boolean('drink');
			$table->enum('blood_group', array('A-', 'A+', 'B-', 'B+', 'O-', 'O+'))->nullable();
			$table->string('photos')->nullable();
			$table->integer('credits');
			$table->tinyInteger('min_age')->nullable();
			$table->tinyInteger('max_age');
			$table->tinyInteger('min_height')->nullable();
			$table->tinyInteger('max_height')->nullable();
			$table->enum('pref_status', array(''));
			$table->string('pref_country');
			$table->string('pref_religion');
			$table->string('pref_caste');
			$table->string('pref_manglik');
			$table->string('pref_education');
			$table->string('min_income')->nullable();
			$table->string('max_income')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('User');
	}
}