<?php

namespace App;

class Expert extends Eloquent {

	protected $table = 'experts';
	public $timestamps = true;
	protected $guarded = array('id', 'code');

	public function categories()
	{
		return $this->belongsToMany('TahaAzzabi\Categorie');
	}

	public function day()
	{
		return $this->belongsToMany('TahaAzzabi\Day');
	}

	public function comment()
	{
		return $this->hasMany('TahaAzzabi\Comment');
	}

	public function language()
	{
		return $this->belongsToMany('TahaAzzabi\Language');
	}

	public function communication()
	{
		return $this->belongsToMany('TahaAzzabi\Communication');
	}

	public function countrie()
	{
		return $this->belongsTo('TahaAzzabi\Countrie');
	}

}