<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class App extends Model 
{

    protected $table = 'app';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar');

    public function categories()
    {
        return $this->hasMany('Category', 'app_id');
    }

    public function posts()
    {
        return $this->hasMany('Post', 'app_id');
    }

}