<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('app_id', 'name_en', 'name_ar');

    public function app()
    {
        return $this->belongsTo('App', 'app_id');
    }

    public function posts()
    {
        return $this->hasMany('Post', 'category_id');
    }

}