<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'post';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'content', 'app_id', 'category_id');

    public function app()
    {
        return $this->belongsTo('App', 'app_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

}