<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('post', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title')->nullable();
			$table->longText('content')->nullable();
			$table->integer('app_id')->nullable();
			$table->integer('category_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('post');
	}
}