<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class App extends Eloquent {

	protected $table = 'app';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar');

	public function categories()
	{
		return $this->hasMany('Category', 'app_id');
	}

	public function posts()
	{
		return $this->hasMany('Post', 'app_id');
	}

}