<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Student_Payment extends Model 
{

    protected $table = 'student_payment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('total_value', 'discount_id', 'student_id', 'state');

    public function student()
    {
        return $this->belongsTo('App\Student');
    }

    public function discount()
    {
        return $this->belongsTo('App\Discount');
    }

    public function payment_details()
    {
        return $this->hasMany('App\Payment_details');
    }

}