<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Student_Payment extends Eloquent {

	protected $table = 'student_payment';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('total_value', 'discount_id', 'student_id', 'state');

	public function student()
	{
		return $this->belongsTo('App\Student');
	}

	public function discount()
	{
		return $this->belongsTo('App\Discount');
	}

	public function payment_details()
	{
		return $this->hasMany('App\Payment_details');
	}

}