<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Payment_discount extends Eloquent {

	protected $table = 'payment_discount';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('payment_id', 'discount_id');

	public function payment()
	{
		return $this->belongsTo('App\Payment');
	}

	public function discount()
	{
		return $this->belongsTo('App\Discount');
	}

}