<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Student extends Eloquent {

	protected $table = 'student';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('fname', 'lname', 'gender', 'image', 'date_of_birth', 'religion', 'blood_group', 'mobile', 'email', 'guardian_id', 'address_id', 'admission_id');

	public function guardian()
	{
		return $this->belongsTo('App\Guardian');
	}

	public function address()
	{
		return $this->belongsTo('App\Address');
	}

	public function payments()
	{
		return $this->hasMany('App\Student_Payment');
	}

	public function family()
	{
		return $this->belongsToMany('App\Student');
	}

}