<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentTable extends Migration {

	public function up()
	{
		Schema::create('payment', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->text('description');
			$table->integer('value');
			$table->boolean('expiable')->default(0);
			$table->timestamp('expiry_date')->nullable();
			$table->integer('penalty_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('payment');
	}
}