<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('student', function(Blueprint $table) {
			$table->foreign('guardian_id')->references('id')->on('guardian')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('address')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_payment', function(Blueprint $table) {
			$table->foreign('discount_id')->references('id')->on('discount')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_payment', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment', function(Blueprint $table) {
			$table->foreign('penalty_id')->references('id')->on('penalty')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payment')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->foreign('discount_id')->references('id')->on('discount')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->foreign('student_payment_id')->references('id')->on('student_payment')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('family', function(Blueprint $table) {
			$table->foreign('student1')->references('id')->on('student')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('family', function(Blueprint $table) {
			$table->foreign('student2')->references('id')->on('student')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_discount', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payment')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_discount', function(Blueprint $table) {
			$table->foreign('discount_id')->references('id')->on('discount')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('student', function(Blueprint $table) {
			$table->dropForeign('student_guardian_id_foreign');
		});
		Schema::table('student', function(Blueprint $table) {
			$table->dropForeign('student_address_id_foreign');
		});
		Schema::table('student_payment', function(Blueprint $table) {
			$table->dropForeign('student_payment_discount_id_foreign');
		});
		Schema::table('student_payment', function(Blueprint $table) {
			$table->dropForeign('student_payment_student_id_foreign');
		});
		Schema::table('payment', function(Blueprint $table) {
			$table->dropForeign('payment_penalty_id_foreign');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->dropForeign('payment_details_payment_id_foreign');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->dropForeign('payment_details_discount_id_foreign');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->dropForeign('payment_details_student_payment_id_foreign');
		});
		Schema::table('family', function(Blueprint $table) {
			$table->dropForeign('family_student1_foreign');
		});
		Schema::table('family', function(Blueprint $table) {
			$table->dropForeign('family_student2_foreign');
		});
		Schema::table('payment_discount', function(Blueprint $table) {
			$table->dropForeign('payment_discount_payment_id_foreign');
		});
		Schema::table('payment_discount', function(Blueprint $table) {
			$table->dropForeign('payment_discount_discount_id_foreign');
		});
	}
}