<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Family extends Eloquent {

	protected $table = 'family';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('student1', 'student2', 'relation');

	public function student1()
	{
		return $this->belongsTo('App\Student', 'student1');
	}

	public function student2()
	{
		return $this->hasOne('App\Student', 'student2');
	}

}