<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Payment extends Eloquent {

	protected $table = 'payment';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'description', 'value', 'expiable', 'expiry_date', 'penalty_id');

	public function payment_details()
	{
		return $this->hasMany('App\Payment_details');
	}

	public function discount()
	{
		return $this->hasMany('App\Payment_discount');
	}

	public function penalty()
	{
		return $this->belongsTo('App\Penalty');
	}

}