<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Discount extends Model 
{

    protected $table = 'discount';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'start_date', 'end_date', 'value', 'static_value', 'paydiscount', 'time_based');

    public function getStudent_Payment()
    {
        return $this->belongsToMany('App\Student_Payment');
    }

    public function payment()
    {
        return $this->hasMany('App\Payment_discount');
    }

}