<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountTable extends Migration {

	public function up()
	{
		Schema::create('discount', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('title');
			$table->timestamp('start_date')->nullable();
			$table->timestamp('end_date')->nullable();
			$table->double('value');
			$table->boolean('static_value')->default(FALSE);
			$table->boolean('paydiscount');
			$table->boolean('time_based')->default(FALSE);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('discount');
	}
}