<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payment_discount extends Model 
{

    protected $table = 'payment_discount';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('payment_id', 'discount_id');

    public function payment()
    {
        return $this->belongsTo('App\Payment');
    }

    public function discount()
    {
        return $this->belongsTo('App\Discount');
    }

}