<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOperationJobsTable extends Migration {

	public function up()
	{
		Schema::create('operation_jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('tipo')->index();
			$table->string('almacen', 50)->nullable();
			$table->string('mercancia', 50)->nullable();
			$table->string('transfer_from', 20)->nullable();
			$table->string('transfer_to', 20)->nullable();
			$table->boolean('complete')->default(0);
			$table->text('notes')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('operation_jobs');
	}
}