<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOperationTypesTable extends Migration {

	public function up()
	{
		Schema::create('operation_types', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned()->index();
			$table->string('name', 30);
			$table->boolean('facturable')->default(0);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('operation_types');
	}
}