<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Types extends Eloquent {

	protected $table = 'operation_types';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('client_id', 'name', 'facturable');
	protected $visible = array('client_id', 'name', 'facturable');

	public function jobs()
	{
		return $this->hasMany('Operations');
	}

	public function client()
	{
		return $this->belongsTo('Client');
	}

}