<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'cif', 'address', 'phone', 'email', 'calidad_name', 'calidad_email', 'notes', 'logo');
	protected $visible = array('name', 'cif', 'address', 'phone', 'email', 'calidad_name', 'calidad_email', 'notes', 'logo');

	public function gps()
	{
		return $this->hasMany('Gps', 'client_id');
	}

	public function importExportJobs()
	{
		return $this->hasMany('BaseImportExport');
	}

	public function operations()
	{
		return $this->hasMany('Types');
	}

	public function gpsJobs()
	{
		return $this->hasMany('GpsJob');
	}

	public function vacios()
	{
		return $this->hasMany('Vacios');
	}

}