<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GpsJob extends Eloquent {

	protected $table = 'gps_jobs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('client_id', 'chofer', 'matricula', 'gps_id', 'delivery_at', 'delivered_by', 'return_at', 'return_by', 'complete', 'notes');
	protected $visible = array('client_id', 'chofer', 'matricula', 'gps_id', 'delivery_at', 'delivered_by', 'return_at', 'return_by', 'complete', 'notes');

	public function gps()
	{
		return $this->hasOne('Gps');
	}

	public function client()
	{
		return $this->belongsTo('Client');
	}

	public function fromUser()
	{
		return $this->belongsTo('User', 'delivered_by');
	}

	public function toUser()
	{
		return $this->belongsTo('User', 'return_by');
	}

}