<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Operations extends Eloquent {

	protected $table = 'operation_jobs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('tipo', 'almacen', 'mercancia', 'transfer_from', 'transfer_to', 'complete', 'notes');
	protected $visible = array('tipo', 'almacen', 'mercancia', 'transfer_from', 'transfer_to', 'complete', 'notes');

	public function operationType()
	{
		return $this->belongsTo('Types');
	}

}