<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'password', 'admin');
	protected $visible = array('name', 'email', 'admin');

	public function returnedGps()
	{
		return $this->hasMany('GpsJob', 'returned_by');
	}

	public function deliveredGps()
	{
		return $this->hasMany('GpsJob', 'delivered_by');
	}

}