<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Vacios extends Eloquent {

	protected $table = 'vacios';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('client_id', 'tipo', 'matricula', 'parking', 'notes', 'complete');
	protected $visible = array('client_id', 'tipo', 'matricula', 'parking', 'notes', 'complete');

	public function client()
	{
		return $this->belongsTo('Client');
	}

}