<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('cif', 12)->nullable();
			$table->string('address')->nullable();
			$table->string('phone', 30)->nullable();
			$table->string('email', 50)->nullable();
			$table->string('calidad_name', 50)->nullable();
			$table->string('calidad_email', 50)->nullable();
			$table->text('notes')->nullable();
			$table->string('logo')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}