<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGpsTable extends Migration {

	public function up()
	{
		Schema::create('gps', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 20);
			$table->integer('client_id')->unsigned()->index();
			$table->smallInteger('estado')->default('0');
			$table->text('notes')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('gps');
	}
}