<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlafondTable extends Migration {

	public function up()
	{
		Schema::create('plafond', function(Blueprint $table) {
			$table->increments('id_plafond', true);
			$table->integer('id_subvention')->unsigned();
			$table->float('montant_max', 8,2)->default('0');
			$table->mediumInteger('quantite_max')->default('1');
			$table->datetime('date_debut')->nullable();
			$table->tinyInteger('unite_periode')->nullable();
			$table->smallInteger('valeur_periode')->nullable();
			$table->string('libelle', 500)->nullable();
			$table->tinyInteger('type');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('plafond');
	}
}