<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGlobalsTable extends Migration {

	public function up()
	{
		Schema::create('globals', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->text('desc');
			$table->string('phone')->nullable();
			$table->string('website')->nullable();
			$table->integer('country_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('globals');
	}
}