<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBankAccountsTable extends Migration {

	public function up()
	{
		Schema::create('bank_accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('account_number', 255);
			$table->string('account_name_en', 255);
			$table->string('account_name_ar', 255);
			$table->bigInteger('bank_id')->unsigned()->index();
			$table->text('iban');
			$table->string('swift_number', 255);
			$table->text('address_en');
			$table->text('address_ar');
			$table->text('bank_address_en')->nullable();
			$table->string('bank_address_ar')->nullable();
			$table->string('currency_name', 255);
			$table->string('currency_code', 10);
			$table->enum('minor_currency', array('mite', 'cent'));
			$table->timestamp('timestamps');
		});
	}

	public function down()
	{
		Schema::drop('bank_accounts');
	}
}