<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientAttachmentsTable extends Migration {

	public function up()
	{
		Schema::create('client_attachments', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('client_id')->unsigned()->index();
			$table->string('name', 255)->nullable();
			$table->string('type', 255);
			$table->string('file', 255);
			$table->boolean('active')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('client_attachments');
	}
}